Option Infer On

Imports System
Imports System.IO
Imports SautinSoft
Imports SautinSoft.Pdf
Imports SautinSoft.Pdf.Content

Namespace Sample
	Friend Class Sample
		''' <summary>
		''' Form Xobjects.
		''' </summary>
		''' <remarks>
		''' Details: https://sautinsoft.com/products/pdf/help/net/developer-guide/form-xobjects.php
		''' </remarks>
		Shared Sub Main(ByVal args() As String)
			' Before starting this example, please get a free trial key:
			' https://sautinsoft.com/start-for-free/

			' Apply the key here:
			' PdfDocument.SetLicense("...");

			Using document = New PdfDocument()
				Dim form = New PdfForm(document, New PdfSize(200, 200))

				form.Content.BeginEdit()

				Dim textGroup = form.Content.Elements.AddGroup()

				' Add text with the default fill (fill will be inherited from outer PdfFormContent).
				Using formattedText = New PdfFormattedText()
					formattedText.Font = New PdfFont("Helvetica", 24)
					formattedText.Append("Hello world!")

					' Draw the formatted text at location (50, 150) from the bottom-left corner of the group/form.
					textGroup.DrawText(formattedText, New PdfPoint(50, 150))
				End Using

				' Add the same text with a black fill 50 points below the first text.
				Dim blackText = CType(textGroup.Elements.AddClone(textGroup.Elements.First), PdfTextContent)
				blackText.TextTransform = PdfMatrix.CreateTranslation(0, -50) * blackText.TextTransform
				blackText.Format.Fill.Color = PdfColors.Black

				Dim pathGroup = form.Content.Elements.AddGroup()

				' Add a rectangle path with the default fill (fill will be inherited from the outer PdfFormContent).
				Dim path = pathGroup.Elements.AddPath()
				path.AddRectangle(0, 50, 200, 40)
				path.Format.Fill.IsApplied = True

				' Add the same path with a black fill 50 points below the first path.
				Dim blackPath = pathGroup.Elements.AddClone(path)
				blackPath.Subpaths.Transform(PdfMatrix.CreateTranslation(0, -50))
				blackPath.Format.Fill.Color = PdfColors.Black

				form.Content.EndEdit()

				Dim page = document.Pages.Add()

				' Add the outer PdfFormContent with the default (black) fill.
				' Elements in the inner PdfForm that do not have a fill set, will have the default (black) fill.
				Dim contentGroup = page.Content.Elements.AddGroup()
				Dim formContent1 = contentGroup.Elements.AddForm(form)
				formContent1.Transform = PdfMatrix.CreateTranslation(100, 600)

				' Add the outer PdfFormContent with a green fill.
				' Elements in the inner PdfForm that do not have a fill set, will have a green fill.
				contentGroup = page.Content.Elements.AddGroup()
				Dim formContent2 = contentGroup.Elements.AddForm(form)
				formContent2.Transform = PdfMatrix.CreateTranslation(100, 350)
				formContent2.Format.Fill.Color = PdfColors.Green

				' Add the outer PdfFormContent with a red fill.
				' Elements in the inner PdfForm that do not have a fill set, will have a red fill.
				contentGroup = page.Content.Elements.AddGroup()
				Dim formContent3 = contentGroup.Elements.AddClone(formContent1)
				formContent3.Transform = PdfMatrix.CreateTranslation(100, 100)
				formContent3.Format.Fill.Color = PdfColors.Red

				document.Save("FormXObjects.pdf")
			End Using

			System.Diagnostics.Process.Start(New System.Diagnostics.ProcessStartInfo("FormXObjects.pdf") With {.UseShellExecute = True})
		End Sub
	End Class
End Namespace
